package com.kuaike.scrm.common.constants;

import java.util.regex.Pattern;

/**
 * desc: 增强版ID打通所使用的常量定义
 *
 * @author yanmaoyuan
 * @date 2022/6/16
 */
public final class VipIdTranslateConstants {

    private VipIdTranslateConstants() {
        // 不要实例化这个类
    }

    // 外部联系人的description字段长度限制，超过这个长度就不要改备注了。
    public static final int DESC_MAX_LENGTH = 120;

    // 修改description时的前后缀
    public static final String DESC_HEAD = "#wr";
    public static final String DESC_SUFFIX = "#";

    // 用于识别description字段中是否包含特殊标识的正则表达式
    public static final Pattern DESC_REGEX = Pattern.compile(DESC_HEAD + "([0-9a-zA-Z]+)" + DESC_SUFFIX);

    /**
     * 用于获取企业微信二维码的 vcode 参数的正则表达式。
     */
    public static final Pattern NORMAL_VCODE_REGEX = Pattern.compile("vcode=([a-z0-9]+)");

    public static final Pattern VIP_VCODE_REGEX = Pattern.compile("/u/([a-z0-9]+)");


}
