/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum TaskStatus {
    NORMAL(1, "\u542f\u7528"),
    BANED(0, "\u7981\u7528");

    private Integer value;
    private String desc;
    private static Map<Integer, TaskStatus> map;

    public static TaskStatus getType(Integer type) {
        return map.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (TaskStatus type : TaskStatus.values()) {
            if (!desc.equals(type.getDesc())) continue;
            return type.getValue();
        }
        return null;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private TaskStatus(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    static {
        map = Maps.newHashMap();
        for (TaskStatus type : TaskStatus.values()) {
            map.put(type.value, type);
        }
    }
}

