/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum NoticeType {
    SYSTEM(0, "\u7cfb\u7edf\u6d88\u606f"),
    CRM_APPOINTMENT(1, "CRM\u9884\u7ea6\u6d88\u606f");

    private int type;
    private String desc;
    private static final Map<Integer, NoticeType> MAP;

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private NoticeType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static NoticeType getByType(int type) {
        return MAP.get(type);
    }

    static {
        MAP = Arrays.stream(NoticeType.values()).collect(Collectors.toMap(NoticeType::getType, Function.identity()));
    }
}

