/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.vip.dto.model;

import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AbstractDispatcher.class);

    public void dispatch(WeworkMessage weworkMessage) {
        Integer contentType = weworkMessage.getContentType();
        if (contentType == null) {
            log.warn("contentType is null, requestId={}", (Object)weworkMessage.getRequestId());
            return;
        }
        switch (contentType) {
            case 0: 
            case 2: {
                this.text(weworkMessage);
                break;
            }
            case 7: 
            case 14: 
            case 101: {
                this.image(weworkMessage);
                break;
            }
            case 104: {
                this.emotion(weworkMessage);
                break;
            }
            case 9: 
            case 16: {
                this.voice(weworkMessage);
                break;
            }
            case 5: 
            case 17: 
            case 23: {
                this.video(weworkMessage);
                break;
            }
            case 102: {
                this.file(weworkMessage);
                break;
            }
            case 13: {
                this.link(weworkMessage);
                break;
            }
            case 41: {
                this.personalCard(weworkMessage);
                break;
            }
            case 1002: {
                this.addRoomMember(weworkMessage);
                break;
            }
            case 1011: {
                this.textControl(weworkMessage);
                break;
            }
            default: {
                this.unknown(weworkMessage);
            }
        }
    }

    public boolean unknown(WeworkMessage weworkMessage) {
        log.info("Unknown contentType:{}, requestId:{}", (Object)weworkMessage.getContentType(), (Object)weworkMessage.getRequestId());
        return false;
    }

    public boolean text(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean image(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean emotion(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean voice(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean video(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean file(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean link(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean personalCard(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean addRoomMember(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean textControl(WeworkMessage weworkMessage) {
        return false;
    }
}

