package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OauthShortUrlTypeEnum implements EnumService {

	WECHAT_MSG_SENSITIVE_URL(0, "微信消息自动对敏感链接打包"),

	MERCHANT_WRAP_URL(1, "商户请求对投放渠道的链接进行打包"),

	RADAR_URL(2, "互动雷达链接进行打包"),

	DYNAMIC_FORM_URL(3, "动态表单链接打包"),

	ADD_FRIEND_URL(4, "专属获客码链接打包"),

	MEETING_AUTH_URL(5,"直播带货类型会议的授权地址"),

	MEETING_ORDER_DETAIL_URL(6,"直播带货订单详情地址")

	;

	private static final Map<Integer, OauthShortUrlTypeEnum> CACHE;

	static {
		CACHE = Arrays.stream(values()).collect(Collectors.toMap(OauthShortUrlTypeEnum::getValue, Function.identity()));
	}

	private final int value;

	private final String desc;

	OauthShortUrlTypeEnum(int value, String desc) {
		this.value = value;
		this.desc = desc;
	}

	public int getValue() {
		return value;
	}

	public String getDesc() {
		return desc;
	}

	public static OauthShortUrlTypeEnum get(Integer value) {
		return CACHE.get(value);
	}
}
