package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum DeptModMsgType implements EnumService{
    USER_MOD(1,"成员变更"),
    DEL_DEPT(2,"部门被删除")
    ;

    private final int id;
    private final String name;

    DeptModMsgType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, DeptModMsgType> cache;

    static {
        cache = new HashMap<>();
        for (DeptModMsgType item : DeptModMsgType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static DeptModMsgType get(int status) {
        return cache.get(status);
    }

}
