/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.event.context;

import lombok.extern.slf4j.Slf4j;

/**
 * @title ReplyContextUtil
 * @author yanmaoyuan
 * @date 2021年6月5日
 * @version 1.0
 */
@Slf4j
public class ReplyContextUtil {

    private ReplyContextUtil() {}

    public static final ThreadLocal<ReplyContext> THREAD_LOCAL = new InheritableThreadLocal<ReplyContext>() {
        @Override
        protected ReplyContext initialValue() {
            return new ReplyContext();
        }
    };

    public static void put(ReplyContext ctx) {
        log.info("ReplyContextUtil,put ctx:{}", ctx);
        THREAD_LOCAL.set(ctx);
    }

    public static ReplyContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

}
