package com.kuaike.scrm.common.enums.applet;

import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2022/01/22
 * 小程序官方审核状态
 **/
@Getter
public enum WxAppletAuditStatus {

    /**
     * 小程序审核通过
     */
    WEAPP_AUDIT_SUCCESS(1,"weapp_audit_success"),

    /**
     * 小程序审核不通过
     */
    WEAPP_AUDIT_FAIL(2,"weapp_audit_fail"),

    /**
     * 审核延后
     */
    WEAPP_AUDIT_DELAY(3,"weapp_audit_delay")

    ;

    private final Integer status;
    private final String desc;

    WxAppletAuditStatus(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    private static final Map<Integer, WxAppletAuditStatus> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(WxAppletAuditStatus::getStatus, Function.identity()));
    }

    public static boolean isExistByStatus(int type){
        return MAP.containsKey(type);
    }
}