package com.kuaike.scrm.common.enums.alloc;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分配规则
 *
 * @author zhangbing
 */
@SuppressWarnings("common-java:DuplicatedBlocks")
public enum AllocStatus {


    NORMAL(0, "正常"),

    ONGOING(1, "分配中"),

    STOP(2, "停用"),

    FULL(3, "分满"),

    BACKUP(4, "启用备用");

    public static final Map<Integer, AllocStatus> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(AllocStatus::getStatus, Function.identity()));
    }

    private int status;

    private String label;

    AllocStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static AllocStatus get(int status) {
        return MAP.get(status);
    }
}
