package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum WeworkNotifyTypeEnums implements EnumService {
    SELL_DAILY_NOTIFY(1, "销售日报通知"),
    MAKE_DEAL_NOTIFY(2, "成单喜报通知");

    private final int id;
    private final String desc;

    WeworkNotifyTypeEnums(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, WeworkNotifyTypeEnums> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (WeworkNotifyTypeEnums item : WeworkNotifyTypeEnums.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static WeworkNotifyTypeEnums get(Integer status) {
        return CACHE.get(status);
    }

    public static String getWeworkNotifyTypeDesc(Integer status) {
        return Optional.ofNullable(CACHE.get(status)).map(WeworkNotifyTypeEnums::getDesc).orElse(null);

    }
}
