/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.EnumService;
import java.util.Map;

public enum SendStatus implements EnumService
{
    TO_BE_QUERY(-1, "\u5f85\u67e5\u8be2"),
    TO_BE_SEND(0, "\u5f85\u53d1\u9001"),
    SENDING(1, "\u53d1\u9001\u4e2d"),
    ALREADY_SEND(2, "\u5df2\u53d1\u9001"),
    ALREADY_EXPIRE(3, "\u5df2\u8fc7\u671f"),
    SEND_FAIL(4, "\u53d1\u9001\u5931\u8d25");

    private Integer value;
    private String desc;
    private static Map<Integer, SendStatus> map;

    public static SendStatus getType(Integer type) {
        return map.get(type);
    }

    public static SendStatus getTypeForWeb(Integer type) {
        if (type != null && type.intValue() == TO_BE_QUERY.getValue()) {
            return TO_BE_SEND;
        }
        return map.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (SendStatus type : SendStatus.values()) {
            if (!desc.equals(type.getDesc())) continue;
            return type.getValue();
        }
        return null;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    private SendStatus(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    static {
        map = Maps.newHashMap();
        for (SendStatus type : SendStatus.values()) {
            map.put(type.value, type);
        }
    }
}

