/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import com.kuaike.scrm.common.enums.EnumService;
import java.util.HashMap;
import java.util.Map;

public enum MaterialType implements EnumService
{
    IMAGE(1, "image"),
    FILE(2, "file"),
    VOICE(3, "voice"),
    VIDEO(4, "video");

    private int value;
    private String desc;
    private static final Map<Integer, MaterialType> cache;

    private MaterialType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public static MaterialType get(int status) {
        return cache.get(status);
    }

    static {
        cache = new HashMap<Integer, MaterialType>(4);
        for (MaterialType item : MaterialType.values()) {
            cache.put(item.getValue(), item);
        }
    }
}

