package com.kuaike.scrm.common.enums.voicecall;

import com.kuaike.scrm.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2022/03/01
 */
public enum VoiceMaterialTypeEnum implements EnumService {
    /**
     * 文本
     */
    TEXT(1, "文本"),
    VOICE(2, "语音");

    private int value;
    private String name;

    VoiceMaterialTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, VoiceMaterialTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (VoiceMaterialTypeEnum item : VoiceMaterialTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static VoiceMaterialTypeEnum get(Integer value) {
        return cache.get(value);
    }
}
