package com.kuaike.scrm.common.enums.applet;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2022/01/21
 * 开店状态：0，未完成开店；1，完成开店；
 **/
@Getter
public enum ShopAvailableStatus {

    /**
     * 未完成开店
     */
    UNAVAILABLE(0,"未完成开店"),
    AVAILABLE(1,"完成开店"),

    ;

    private Integer status;
    private String desc;

    ShopAvailableStatus(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    private static Map<Integer, ShopAvailableStatus> map = Maps.newHashMap();

    static {
        for (ShopAvailableStatus status : ShopAvailableStatus.values()) {
            map.put(status.status, status);
        }
    }

    public static boolean isExistByStatus(int type){
        return map.containsKey(type);
    }
}