package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 接替状态枚举类
 */
public enum TakeoverStatus implements EnumService{

    FAIL(0, "失败"),
    FINISH(1, "接替完毕"),
    WAIT_TAKEOVER(2, "接替中"),
    REFUSED(3, "客户拒绝"),
    OVER_LIMIT(4, "接替成员客户达到上限"),
    NO_RECORD(5, "无接替记录");

    private int id;
    private String name;

    TakeoverStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, TakeoverStatus> cache;

    static {
        cache = new HashMap<>(2);
        for (TakeoverStatus item : TakeoverStatus.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static TakeoverStatus get(int status) {
        return cache.get(status);
    }
}
