package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;


public enum SexEnum implements EnumService {
    UNKNOWN(0, "未知"),
    MALE(1, "男"),
    FEMALE(2, "女");

    private int id;
    private String name;

    SexEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, SexEnum> cache;

    static {
        cache = new HashMap<>(2);
        for (SexEnum item : SexEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static SexEnum get(int status) {
        return cache.get(status);
    }
}
