package com.kuaike.scrm.common.enums;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum RadarShareType {
    NOT_LIMIT(0, "无游客限制"),

    ADD_SHARE(1, "按分享人加好友"),

    ADD_WEWORKUSER(2, "按指定成员加好友");

    private int value;

    private String desc;


    RadarShareType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, RadarShareType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(RadarShareType.values()).collect(Collectors.toMap(RadarShareType::getValue, Function.identity())));
    }


    public static RadarShareType getType(Integer value) {
        return MAP.get(value);
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }
}
