package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/6/4 3:09 下午
 */
public enum QueryType {

    DEFAULT(0,""),

    Contact(1, "联系人查询"),

    Chatroom(2, "群查询"),

    QrCode(3, "活码查询");

    private int type;

    private String desc;

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    QueryType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, QueryType> MAP;

    static {
        MAP = Arrays.stream(QueryType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }

    public static QueryType getByType(int type) {
        return MAP.get(type);
    }
}
