package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum QualityCheckType {
    WORD(0, "敏感词"),

    BEHAVIOR(1, "敏感行为"),
    ;

    private Integer type;

    private String desc;

    QualityCheckType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, QualityCheckType> MAP;

    static {
        MAP = Arrays.stream(QualityCheckType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }

    public static QualityCheckType getByType(int type) {
        return MAP.get(type);
    }
}
