package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangjing
 * @date 2021/4/29 10:33 上午
 */
public enum PublishPayloadType {

    ConversationMsgSavePrivateKeyChange(1, "会话存档私钥更新"),

    QualityCheckWordChange(2, "质检敏感词更新"),

    QualityCheckBehaviorChange(3, "质检敏感行为更新"),

    ;

    private int type;

    private String desc;

    PublishPayloadType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, PublishPayloadType> cache;

    static {
        cache = new HashMap<>();
        for (PublishPayloadType item : PublishPayloadType.values()) {
            cache.put(item.getType(), item);
        }
    }

    public static PublishPayloadType getType(int type) {
        return cache.get(type);
    }
}
