package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum PlanType {
    CHANNEL_PLAN(1, "渠道活码"),
    REGION_PLAN(2, "区域活码"),
    FRIEND_FISSION_PLAN(3, "助力裂变"),
    ROOM_PLAN(4, "群活码");

    private int value;
    private String desc;

    PlanType(int vaule, String desc) {
        this.value = vaule;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, PlanType> cache;

    static {
        cache = new HashMap<>(3);
        for (PlanType item : PlanType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static PlanType get(int status) {
        return cache.get(status);
    }
}
