/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */
public enum OrgTypeEnum implements EnumService {
    HEAD_OFFICE(1, "总部"),
    BRANCH_SCHOOL(2, "分校"),
    ;

    private int id;
    private String desc;

    private OrgTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, OrgTypeEnum> cache;

    static {
        cache = new HashMap<>(3);
        for (OrgTypeEnum item : OrgTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static OrgTypeEnum get(int status) {
        return cache.get(status);
    }
}