package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum OnLineType {
    DAY_LINE_TYPE(1, "全天候在线"),
    TIME_LINE_TYPE(2, "分时段在线");



    private int value;
    private String desc;

    OnLineType(int vaule, String desc) {
        this.value = vaule;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, OnLineType> cache;

    static {
        cache = new HashMap<>(2);
        for (OnLineType item : OnLineType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static OnLineType get(int value) {
        return cache.get(value);
    }
}
