package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 会议 客户来源
 * @author: lwl
 * @date: 2021/6/3
 **/
public enum MeetingSource implements EnumService{
    WEWORK_FRIEND(0,"企业微信好友"),
    OTHER_EXTERNAL(1,"其他外部邀请"),
    CHANNEL(2, "渠道");

    private int value;
    private String desc;

    MeetingSource(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MeetingSource> cache;

    static {
        cache = new HashMap<>(2);
        for (MeetingSource item : MeetingSource.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static MeetingSource get(int status) {
        return cache.get(status);
    }
}
