package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum MarketingConfigType {
    AUTO_REMARK(1, "自动备注"),

    FRIEND_WELCOME(2, "好友欢迎语"),

    SPREAD_REPLY(3, "好友裂变推广话术"),

    SUCCESS_INVITE_REPLY(4, "成功推广话术"),

    REPEAT_INVITE_REPLY(5, "重复助力话术"),

    FINISH_REPLY(6, "活动结束话术"),

    LIMIT_NEW_CUSTOMER_REPLY(7, "新好友才能助力回复话术"),

    FISSION_BILL_BOARD(8, "海报配置"),

    FISSION_SWITCH(9, "好友裂变配置");

    private int value;

    private String desc;

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MarketingConfigType> cache;


    static {
        cache = new HashMap<>(4);
        for (MarketingConfigType item : MarketingConfigType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static MarketingConfigType get(int status) {
        return cache.get(status);
    }

    MarketingConfigType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }
}
