package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/5/31 4:17 下午
 */
public enum JsMsgType {
    // 官方消息类型
    text,

    image,

    video,

    file,

    news,

    miniprogram,
    // 业务消息类型
    meeting,

    ffWords,
    ;

    final static Set<String> sets;

    static {
        sets = Arrays.stream(JsMsgType.values()).map(a->a.name()).collect(Collectors.toSet());
    }

    public static boolean contains(String typeName){
        return sets.contains(typeName);
    }

    public static String getMsgName(JsMsgType typeName) {
        switch (typeName) {
            case text:        return "文本";
            case image:       return "图片";
            case video:       return "视频";
            case file:        return "文件";
            case news:        return "新闻";
            case miniprogram: return "小程序";
            case meeting:     return "会议";
            case ffWords:     return "好友裂变";
            default:          return "";
        }
    }
}
