package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum HandleQyAccountType implements EnumService{
    CLOSE(0, "关闭百家云SCRM"),
    OPEN(1, "开通百家云SCRM"),
    ;

    private int id;
    private String desc;

    HandleQyAccountType(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, HandleQyAccountType> cache;

    static {
        cache = new HashMap<>();
        for (HandleQyAccountType item : HandleQyAccountType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static HandleQyAccountType get(int status) {
        return cache.get(status);
    }

}
