/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 群发企业成员状态
 * 
 * @title GroupSendUserStatus
 * @author yanmaoyuan
 * @date 2021年6月22日
 * @version 1.0
 * @see https://open.work.weixin.qq.com/api/doc/90000/90135/93338
 */
public enum GroupSendUserStatus implements EnumService {

    FAILED(-1, "发送失败"),

    NOT_SEND(0, "未发送"),

    SENT(2, "已发送")
    ;

    private int value;
    private String desc;

    private GroupSendUserStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private final static Map<Integer, GroupSendUserStatus> CACHE = new HashMap<>();

    static {
        for (GroupSendUserStatus e:values()) {
            CACHE.put(e.value, e);
        }
    }

    public static GroupSendUserStatus get(Integer value) {
        return CACHE.get(value);
    }
}
