package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 *
 * 跟进记录类型
 */
public enum FollowRecordType implements EnumService {
    EDIT_CONTACT_INFO(1, "客户资料更新"),
    UPDATE_CONTACT_STAGE(2, "客户阶段更新"),
    FOLLOW_INFO(3, "客户跟进"),
    EDIT_CONTACT_TAG(4, "客户标签更新"),
    TRANSFER_CONTACT(5, "客户继承"),
    CUSTOMER_FOLLOW(6, "雷达客户动态"),
    FORM_CUSTOMER_FOLLOW(11, "动态表单客户动态")
    ;

    private int id;
    private String name;

    FollowRecordType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, FollowRecordType> cache;

    static {
        cache = new HashMap<>(5);
        for (FollowRecordType item : FollowRecordType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static FollowRecordType get(int status) {
        return cache.get(status);
    }
}
