package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 跟进记录消息类型
 * @author: lwl
 * @date: 2022/3/4
 **/
public enum FollowRecordMsgType implements EnumService{
    CALL(1, "电话外呼"),
    SMS(2, "短信"),
    WEWORK_CHAT(3, "企业微信聊天"),
    ;

    private final int value;

    private final String desc;

    FollowRecordMsgType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private final static Map<Integer, FollowRecordMsgType> CACHE;

    static {
        Map<Integer, FollowRecordMsgType> map = new HashMap<>();
        for (FollowRecordMsgType e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static FollowRecordMsgType getType(Integer value) {
        return CACHE.get(value);
    }
}
