package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ExportTaskType {
    CONTACT(1, "contactExport"),

    GLOBAL(2, "globalExport"),

    ;

    private int value;
    private String desc;

    ExportTaskType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ExportTaskType> cache;

    static {
        cache = new HashMap<>();
        for (ExportTaskType item : ExportTaskType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ExportTaskType get(Integer value) {
        return cache.get(value);
    }
}
