package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * author: jw
 * date: 2021/12/22 下午5:43
 * content:
 */
public enum DynamicFormStatus implements EnumService {
    DRAFT(1, "草稿"),
    RELEASE(2, "已发布"),
    END(3, "已截止"),
    ;

    DynamicFormStatus(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    private int id;
    private String desc;

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, DynamicFormStatus> cache;

    static {
        cache = new HashMap<>(5);
        for (DynamicFormStatus item : DynamicFormStatus.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static DynamicFormStatus get(int status) {
        return cache.get(status);
    }
}
