package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * author: jw
 * date: 2021/12/24 上午11:27
 * content:
 */
public enum DynamicFormMoment implements EnumService {
    OPEN_FORM(1, "进入表单"),
    SUBMIT_FORM(2, "提交表单"),
    ;

    DynamicFormMoment(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    private int id;
    private String desc;

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, DynamicFormMoment> cache;

    static {
        cache = new HashMap<>(5);
        for (DynamicFormMoment item : DynamicFormMoment.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static DynamicFormMoment get(int status) {
        return cache.get(status);
    }
}


