package com.kuaike.scrm.common.enums;

/**
 * @author sunwen
 */
public enum CustomerStageEnum {
    STAGE_ONE(1,"0%", "初始入库"),
    STAGE_TWO(1,"25%", "客户信息准确"),
    STAGE_THREE(1,"50%", "客户有购买需求"),
    STAGE_FOUR(1,"75%", "确定意向并在2周内付款"),
    DEAL(1, "100%", "已成单"),
    INVALID_CUSTOMER(2, "", "无效客户"),
    SHU_DAN(2, "", "已输单");



    private Integer type;
    private String value;
    private String desc;

    CustomerStageEnum(int type, String value, String desc) {
        this.type = type;
        this.value = value;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
