package com.kuaike.scrm.common.enums;


import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 */

public enum BizStatus implements EnumService {
    NORMAL(1, "正常"),
    FORBID(2, "禁用"),
    INVALID(3, "过期");

    private int id;
    private String name;

    BizStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, BizStatus> cache;

    static {
        cache = new HashMap<>(3);
        for (BizStatus item : BizStatus.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static BizStatus get(int status) {
        return cache.get(status);
    }
}
