package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum AutoPassType {

    DAY_PASS_TYPE(1, "全天候自动通过"),
    TIME_PASS_TYPE(2, "分时段自动通过");



    private int value;
    private String desc;

    AutoPassType(int vaule, String desc) {
        this.value = vaule;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, AutoPassType> cache;

    static {
        cache = new HashMap<>(2);
        for (AutoPassType item : AutoPassType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static AutoPassType get(int value) {
        return cache.get(value);
    }
}
