/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.constants;

/**
 * @author yanmaoyuan
 * @version 1.0
 * @title Conf
 * @date 2021年1月17日
 */
public interface Conf {

    long FRONT_SESSION_TIMEOUT = 60L * 60 * 24 * 30;  //  30天

    String ROC_LOGIN_KEY = "ROC_LOGIN_KEY_%s";

    String ROC_LOING_USER_NAME = "ROC_LOING_USER_NAME";

    /**
     * SnsUserinfo的缓存过期时间，单位:秒
     */
    int SNS_CACHE_EXPIRE = 3600;

    /**
     * 设置的cookie名字
     */
    String SNS_USERINFO_TOKEN = "SNS_USERINFO_TOKEN";

    /**
     * pv/uv 上报时确定客户的cookie 名
     */
    String SNS_UNIQ_ID = "SNS_UNIQ_ID";

    // AES算法需要的KEY
    String FRONT_AES_KEY = "QAQWSXCDERFVBGTY";

    String xssAndSqlShield_excludeUrls = "_xssAndSqlShield_excludeUrls";

    String xssAndSqlShield_trigger = "_xssAndSqlShield_trigger";

    int MAX_ROOM_COUNT = 300;

    /**
     * 能够邀请扫码入群的成员数量上限，超过这个成员数量的群将没有二维码，无法扫码入群。
     */
    int MAX_ROOM_MEMBER_COUNT = 200;

    String[] INVALID_CUSTOMER_REASONS = new String[]{"多次联系不上", "空号/错号/停机", "客户无需求", "其他"};

    String[] SHU_DAN_REASONS = new String[]{"客户选择了其它机构", "产品无法满足客户需求", "其他"};

    /**
     * 单个成员最多客户数为50000
     */
    int MAX_CONTACT_COUNT = 50000;

    String CHANNEL_REGION_KEY_FORMAT = "channelId:{0}-regionInfoId:{1}";

    String EMPTY_SEND_WEWORK_USER_NUM = "emptyUserNum";

    String EMPTY_RECEIVE_ID = "emptyReceiverId";

    int ENLARGE_FACTOR = 10000;

    int SHOW_MAX_STAGE = 3;

    String DEFAULT_CHANNEL_NAME = "企业微信";

    /**
     * 用户昵称占位符
     */
    String FRIEND_FISSION_CONTACT_NICKNAME = "${nickname}";

    /**
     * 阶段一剩余奖品数量占位符
     */
    String FRIEND_FISSION_REMAIN_REWARD_1 = "${remainReward-1}";

    /**
     * 阶段二剩余奖品数量占位符
     */
    String FRIEND_FISSION_REMAIN_REWARD_2 = "${remainReward-2}";

    /**
     * 阶段三剩余奖品数量占位符
     */
    String FRIEND_FISSION_REMAIN_REWARD_3 = "${remainReward-3}";

    /**
     * 试用账号限制
     **/
    String TRAIL_ACCOUNT_LIMIT = "账号数量已达到上限，请联系企业管理员";

    /**
     * 正式账号限制
     **/
    String NORMAL_ACCOUNT_LIMIT = "账号数量已达到上限，请联系企业管理员";

    String QRCODE_TASK_MSG_PRE = "qrcodeSubTask";

    String QRCODE_TASK_STATE_PRE = "AD_";

    String NET_SCHOOL_FIRST_CODE = "27";

    String NET_SCHOOL_SECOND_CODE = "2701";

    String RADAR_QRCODE_PER = "RD_";

    String FILE_TYPE_MP4 = "mp4";

    /**
     * web端识别的语言格式
     */
    public static final String FILE_SUFFIX_MP4 = ".mp4";
}
