/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.vip.dto.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum WxError {
    UNKNOWN(0, ""),
    UN_VERIFIED(207, "\u4e3a\u65b9\u4fbf\u5bf9\u65b9\u51c6\u786e\u8bc6\u522b\u4f60\uff0c\u6dfb\u52a0\u597d\u53cb\u524d\u8bf7\u5148\u5b8c\u6210\u5b9e\u540d\u8ba4\u8bc1");

    private int errCode;
    private String reason;
    private static final Map<String, WxError> MAP;

    private WxError(int errCode, String reason) {
        this.errCode = errCode;
        this.reason = reason;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getReason() {
        return this.reason;
    }

    public static String getReasonStr(int errCode) {
        String key = StringUtils.join((Object[])new Integer[]{errCode}, (String)"##");
        WxError error = MAP.get(key);
        if (error == null) {
            return "";
        }
        return error.getReason();
    }

    static {
        MAP = Maps.newHashMap();
        MAP.putAll(Arrays.stream(WxError.values()).collect(Collectors.toMap(a -> StringUtils.join((Object[])new Integer[]{a.getErrCode()}, (String)"##"), a -> a)));
    }
}

