/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum QueryType {
    DEFAULT(0, ""),
    CONTACT(1, "\u8054\u7cfb\u4eba\u67e5\u8be2"),
    CHAT_ROOM(2, "\u7fa4\u67e5\u8be2"),
    QRCODE(3, "\u6d3b\u7801\u67e5\u8be2");

    private int type;
    private String desc;
    private static final Map<Integer, QueryType> MAP;

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private QueryType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static QueryType getByType(int type) {
        return MAP.get(type);
    }

    static {
        MAP = Arrays.stream(QueryType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }
}

