/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.kafka.producer;

import com.kuaike.kafka.exception.KafkaClientException;
import com.kuaike.kafka.producer.ProducerClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ProducerClientBuilder<K, V> {
    private Map<String, String> propsTemplate = new HashMap<String, String>();
    Properties props;

    public ProducerClientBuilder(String bootstrapServers) {
        this.props = new Properties();
        this.bootstrapServers(bootstrapServers);
        this.acks("all");
        this.keySerializer("org.apache.kafka.common.serialization.StringSerializer");
        this.valueSerializer("org.apache.kafka.common.serialization.StringSerializer");
    }

    public ProducerClientBuilder() {
        throw new KafkaClientException("Please use constructor with args .");
    }

    public ProducerClientBuilder bootstrapServers(String brokers) {
        this.propsTemplate.put("bootstrap.servers", brokers);
        return this;
    }

    public ProducerClientBuilder acks(String acks) {
        this.propsTemplate.put("acks", acks);
        return this;
    }

    public ProducerClientBuilder lingerMs(String lingerMs) {
        this.propsTemplate.put("linger.ms", lingerMs);
        return this;
    }

    public ProducerClientBuilder retries(String retries) {
        this.propsTemplate.put("retries", retries);
        return this;
    }

    public ProducerClientBuilder batchSize(String batchSize) {
        this.propsTemplate.put("batch.size", batchSize);
        return this;
    }

    public ProducerClientBuilder bufferMemory(String bufferMemory) {
        this.propsTemplate.put("buffer.memory", bufferMemory);
        return this;
    }

    public ProducerClientBuilder producerType(String producerType) {
        this.propsTemplate.put("producer.type", producerType);
        return this;
    }

    public ProducerClientBuilder keySerializer(String keySerializer) {
        this.propsTemplate.put("key.serializer", keySerializer);
        return this;
    }

    public ProducerClientBuilder valueSerializer(String valueSerializer) {
        this.propsTemplate.put("value.serializer", valueSerializer);
        return this;
    }

    public ProducerClientBuilder requestTimeoutMs(String requestTimeoutMs) {
        this.propsTemplate.put("request.timeout.ms", requestTimeoutMs);
        return this;
    }

    public ProducerClientBuilder partitionClass(String partitionClass) {
        this.propsTemplate.put("partitioner.class", partitionClass);
        return this;
    }

    public ProducerClientBuilder compressionType(String compressionType) {
        this.propsTemplate.put("compression.type", compressionType);
        return this;
    }

    public ProducerClientBuilder interceptorClasses(String partitionClass) {
        this.propsTemplate.put("interceptor.classes", partitionClass);
        return this;
    }

    public ProducerClient<K, V> build() {
        this.props.putAll(this.propsTemplate);
        return new ProducerClient(this.props);
    }
}

