/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.kafka.producer;

import com.kuaike.kafka.exception.KafkaClientException;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerClient<K, V> {
    private static final Logger log = LoggerFactory.getLogger(ProducerClient.class);
    private Properties props;
    private Producer<K, V> producer;

    public ProducerClient(String brokers) {
        this.props = new Properties();
        if (brokers == null || brokers.trim().length() == 0) {
            throw new KafkaClientException("bootstrap.servers must not be empty");
        }
        this.props.put("bootstrap.servers", brokers);
        this.props.put("acks", "all");
        this.props.put("retries", (Object)3);
        this.props.put("batch.size", (Object)16384);
        this.props.put("linger.ms", (Object)1);
        this.props.put("buffer.memory", (Object)0x2000000);
        this.props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(this.props);
    }

    public ProducerClient(String brokers, String partitioner) {
        this.props = new Properties();
        if (brokers == null || brokers.trim().length() == 0) {
            throw new KafkaClientException("bootstrap.servers must not be empty");
        }
        if (partitioner != null && partitioner.trim().length() > 0) {
            this.props.put("partitioner.class", partitioner);
        }
        this.props.put("bootstrap.servers", brokers);
        this.props.put("acks", "all");
        this.props.put("retries", (Object)3);
        this.props.put("batch.size", (Object)16384);
        this.props.put("linger.ms", (Object)1);
        this.props.put("buffer.memory", (Object)0x2000000);
        this.props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(this.props);
    }

    public ProducerClient(Properties props) {
        if (props.getProperty("bootstrap.servers") == null || props.getProperty("bootstrap.servers").trim().length() == 0) {
            throw new KafkaClientException("bootstrap.servers must not be empty");
        }
        this.props = props;
        this.producer = new KafkaProducer(props);
    }

    public void sendMessage(String topic, K key, V message) {
        if (topic == null || topic.trim().length() == 0) {
            throw new KafkaClientException("topic must not be empty");
        }
        ProducerRecord kMsg = new ProducerRecord(topic, null, Long.valueOf(System.currentTimeMillis()), key, message);
        this.send(kMsg);
    }

    public void sendMessage(String topic, V message) {
        if (topic == null || topic.trim().length() == 0) {
            throw new KafkaClientException("topic must not be empty");
        }
        ProducerRecord kMsg = new ProducerRecord(topic, null, Long.valueOf(System.currentTimeMillis()), (Object)UUID.randomUUID().toString(), message);
        this.send(kMsg);
    }

    public void close() {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    private void send(ProducerRecord<K, V> kMsg) {
        try {
            if (this.isSync()) {
                RecordMetadata metadata2 = (RecordMetadata)this.producer.send(kMsg).get();
                log.info("sync send successful,metadata: {} ,message: {} ", (Object)metadata2, (Object)kMsg.toString());
            } else {
                this.producer.send(kMsg, (metadata, exception) -> {
                    if (exception != null) {
                        log.error(String.format("Exception for sending message %s ", kMsg), (Throwable)exception);
                    }
                    log.info("async send successful,message: {},metadata:{} ", (Object)kMsg.toString(), (Object)metadata);
                });
            }
        }
        catch (Exception e) {
            log.error(String.format("Exception for sending message %s ", kMsg), (Throwable)e);
        }
    }

    private boolean isSync() {
        return "sync".equals(this.props.getProperty("producer.type"));
    }
}

