/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.kafka.consumer.template;

import com.google.common.base.Preconditions;
import com.kuaike.kafka.constants.ConsumeStatus;
import com.kuaike.kafka.consumer.registry.CompensateConsumerRegistry;
import com.kuaike.kafka.consumer.template.MessageConsumeRecordService;
import com.kuaike.kafka.consumer.template.MsgConsumeRecordDto;
import com.kuaike.kafka.consumer.template.NonSuspendMessageConsumer;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MessageCompensateHandler {
    private static final Logger log = LoggerFactory.getLogger(MessageCompensateHandler.class);
    @Autowired
    private CompensateConsumerRegistry registry;
    @Autowired
    private MessageConsumeRecordService messageConsumeRecordService;

    @Transactional
    public void byId(Long messageRecordId) {
        Preconditions.checkArgument((null != messageRecordId ? 1 : 0) != 0, (Object)"\u8865\u507f\u6d88\u606f\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        MsgConsumeRecordDto msgConsumeRecordDto = this.messageConsumeRecordService.getById(messageRecordId);
        Preconditions.checkArgument((null != msgConsumeRecordDto ? 1 : 0) != 0, (Object)("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55\uff0cid=" + messageRecordId));
        Preconditions.checkArgument((ConsumeStatus.CONSUME_FAILED.getStatus() == msgConsumeRecordDto.getConsumeStatus() ? 1 : 0) != 0, (Object)("\u6d88\u606f\u5e76\u6ca1\u5904\u4e8e\u5931\u8d25\u72b6\u6001\uff0c\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + ConsumeStatus.get(msgConsumeRecordDto.getConsumeStatus()).getLabel()));
        String topic = msgConsumeRecordDto.getTopic();
        NonSuspendMessageConsumer messageConsumer = this.registry.getByTopic(topic);
        Preconditions.checkArgument((null != messageConsumer ? 1 : 0) != 0, (Object)("\u5f53\u524d\u4e3b\u9898\u5bf9\u5e94\u7684\u6d88\u8d39\u7aef\u4e0d\u652f\u6301\u8865\u507f\uff0c\u4e3b\u9898\u4e3a\uff1a" + topic));
        log.info("\u5f00\u59cb\u8865\u507f\u6d88\u606f\uff0cid\u4e3a\uff1a{}\uff0c\u4e3b\u9898\u4e3a\uff1a{}\uff0c\u4f7f\u7528\u6d88\u8d39\u7aef\uff1a{}", new Object[]{messageRecordId, topic, messageConsumer.getClass().getCanonicalName()});
        messageConsumer.compensate(msgConsumeRecordDto);
        msgConsumeRecordDto.setConsumeStatus(ConsumeStatus.CONSUME_SUCC.getStatus());
        this.messageConsumeRecordService.update(msgConsumeRecordDto);
        log.info("\u6d88\u606f\u8bb0\u5f55\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff0c\u8865\u507f\u6d88\u606f\u8bb0\u5f55\u4e3a\uff1a{}", (Object)msgConsumeRecordDto.getId());
    }

    public void byIds(Collection<Long> messageRecordIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(messageRecordIds), (Object)"\u8865\u507f\u6d88\u606f\u8bb0\u5f55id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        messageRecordIds.forEach(this::byId);
    }
}

