/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.kafka.consumer.registry;

import com.google.common.base.Preconditions;
import com.kuaike.common.utils.lang.LogUtil;
import com.kuaike.kafka.consumer.registry.CompensateConsumerRegistry;
import com.kuaike.kafka.consumer.template.NonSuspendMessageConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultCompensateConsumerRegistry
implements CompensateConsumerRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultCompensateConsumerRegistry.class);
    private final Map<String, NonSuspendMessageConsumer> map = new ConcurrentHashMap<String, NonSuspendMessageConsumer>();

    @Override
    public void register(String topic, NonSuspendMessageConsumer consumer) {
        Preconditions.checkArgument((null != consumer ? 1 : 0) != 0, (Object)("\u6ce8\u518c\u53d1\u751f\u9519\u8bef\uff0c\u6d88\u8d39\u7aef\u4e3a\u7a7a\uff0c\u4e3b\u9898\u4e3a\uff1a" + topic));
        this.map.put(topic, consumer);
        LogUtil.info((Logger)log, (String)"\u6ce8\u518c\u4e3b\u9898\u3010{}\u3011\u548c\u6d88\u8d39\u7aef\u3010{}\u3011\u7684\u6620\u5c04\u5173\u7cfb", (Object)topic, (Object)consumer.getClass().getCanonicalName());
    }

    @Override
    public NonSuspendMessageConsumer getByTopic(String topic) {
        return this.map.get(topic);
    }
}

