/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.kafka.consumer;

import com.kuaike.kafka.consumer.ConsumerClient;
import com.kuaike.kafka.consumer.ManualCommitConsumerClient;
import com.kuaike.kafka.exception.KafkaClientException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConsumerClientBuilder<K, V> {
    private Map<String, String> propsTemplate = new HashMap<String, String>();
    Properties props;

    public ConsumerClientBuilder(String bootstrapServers, String groupId) {
        this.props = new Properties();
        this.bootstrapServers(bootstrapServers);
        this.groupId(groupId);
        this.keyDeserializer("org.apache.kafka.common.serialization.StringDeserializer");
        this.valueDeserializer("org.apache.kafka.common.serialization.StringDeserializer");
        this.autoOffsetReset("earliest");
    }

    public ConsumerClientBuilder() {
        throw new KafkaClientException("Please use constructor with args .");
    }

    public ConsumerClientBuilder bootstrapServers(String brokers) {
        this.propsTemplate.put("bootstrap.servers", brokers);
        return this;
    }

    public ConsumerClientBuilder groupId(String groupId) {
        this.propsTemplate.put("group.id", groupId);
        return this;
    }

    public ConsumerClientBuilder autoOffsetReset(String autoOffsetReset) {
        this.propsTemplate.put("auto.offset.reset", autoOffsetReset);
        return this;
    }

    public ConsumerClientBuilder requestTimeoutMs(String requestTimeoutMs) {
        this.propsTemplate.put("request.timeout.ms", requestTimeoutMs);
        return this;
    }

    public ConsumerClientBuilder receiveBuffer(String receiveBuffer) {
        this.propsTemplate.put("receive.buffer.bytes", receiveBuffer);
        return this;
    }

    public ConsumerClientBuilder keyDeserializer(String keySerializer) {
        this.propsTemplate.put("key.deserializer", keySerializer);
        return this;
    }

    public ConsumerClientBuilder valueDeserializer(String valueSerializer) {
        this.propsTemplate.put("value.deserializer", valueSerializer);
        return this;
    }

    public ConsumerClientBuilder enableAutoCommit(String enableAutoCommit) {
        this.propsTemplate.put("enable.auto.commit", enableAutoCommit);
        return this;
    }

    public ConsumerClientBuilder autoCommitIntervalMs(String autoCommitIntervalMs) {
        this.propsTemplate.put("auto.commit.interval.ms", autoCommitIntervalMs);
        return this;
    }

    public ConsumerClientBuilder fetchMaxWaitMs(String fetchMaxWaitMs) {
        this.propsTemplate.put("fetch.max.wait.ms", fetchMaxWaitMs);
        return this;
    }

    public ConsumerClientBuilder fetchMinBytes(String fetchMinBytes) {
        this.propsTemplate.put("fetch.min.bytes", fetchMinBytes);
        return this;
    }

    public ConsumerClientBuilder fetchMaxBytes(String fetchMaxBytes) {
        this.propsTemplate.put("fetch.max.bytes", fetchMaxBytes);
        return this;
    }

    public ConsumerClientBuilder partitionAssignmentStrategy(String partitionAssignmentStrategy) {
        this.propsTemplate.put("partition.assignment.strategy", partitionAssignmentStrategy);
        return this;
    }

    public ConsumerClientBuilder maxPollRecords(String maxPollRecords) {
        this.propsTemplate.put("max.poll.records", maxPollRecords);
        return this;
    }

    public ConsumerClientBuilder maxPollIntervalMs(String maxPollIntervalMs) {
        this.propsTemplate.put("max.poll.interval.ms", maxPollIntervalMs);
        return this;
    }

    public ConsumerClientBuilder sessionTimeoutMs(String sessionTimeoutMs) {
        this.propsTemplate.put("session.timeout.ms", sessionTimeoutMs);
        return this;
    }

    public ConsumerClientBuilder heartbeatIntervalMs(String heartbeatIntervalMs) {
        this.propsTemplate.put("heartbeat.interval.ms", heartbeatIntervalMs);
        return this;
    }

    public ConsumerClientBuilder interceptorClasses(String interceptorClass) {
        this.propsTemplate.put("interceptor.classes", interceptorClass);
        return this;
    }

    public ConsumerClientBuilder maxPartitionFetchBytes(String maxPartitionFetchBytes) {
        this.propsTemplate.put("max.partition.fetch.bytes", maxPartitionFetchBytes);
        return this;
    }

    public ConsumerClient<K, V> buildConsumer() {
        this.enableAutoCommit("true");
        this.props.putAll(this.propsTemplate);
        return new ConsumerClient(this.props);
    }

    public ManualCommitConsumerClient<K, V> buildManualCommitConsumer() {
        this.enableAutoCommit("false");
        this.props.putAll(this.propsTemplate);
        return new ManualCommitConsumerClient(this.props);
    }
}

