/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.kafka.constants;

import com.google.common.collect.Maps;
import java.util.Map;

public enum ConsumeStatus {
    UNCONSUME(1, "\u5f85\u5904\u7406"),
    CONSUMING(2, "\u5904\u7406\u4e2d"),
    CONSUME_SUCC(3, "\u5904\u7406\u6210\u529f"),
    CONSUME_FAILED(4, "\u5904\u7406\u5931\u8d25");

    private static Map<Integer, ConsumeStatus> cache;
    private int status;
    private String label;

    private ConsumeStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }

    public static ConsumeStatus get(int status) {
        return cache.get(status);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    static {
        cache = Maps.newHashMap();
        for (ConsumeStatus consumeStatus : ConsumeStatus.values()) {
            cache.put(consumeStatus.getStatus(), consumeStatus);
        }
    }
}

