/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.common.enums.order;

import com.google.common.collect.Maps;
import java.util.Map;

public enum OrderSource {
    OFFLINE(1, "\u7ebf\u4e0b\u62a5\u540d", "XC"),
    AGENT(2, "\u4ee3\u7406\u5546\u8ba2\u5355", "DL"),
    TRANSFER(3, "\u8f6c\u73ed", "ZB"),
    BM(4, "BM", "BM"),
    MZ(5, "M\u7ad9", "MZ"),
    JS(6, "\u6559\u5e08\u5e73\u53f0", "JS"),
    XX(7, "\u5b66\u4e60\u5e73\u53f0", "XX"),
    HA(8, "\u534e\u56feapp\u9762\u6388", "HA"),
    WK(9, "\u536b\u4eba\u673a\u8003", "WK"),
    JY(10, "\u534e\u56fe\u6559\u80b2+app", "JY");

    private int type;
    private String label;
    private String prefix;
    public static Map<Integer, OrderSource> cache;

    private OrderSource(int type, String label, String prefix) {
        this.type = type;
        this.label = label;
        this.prefix = prefix;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public static OrderSource get(int type) {
        return cache.get(type);
    }

    static {
        cache = Maps.newHashMap();
        for (OrderSource orderSource : OrderSource.values()) {
            cache.put(orderSource.getType(), orderSource);
        }
    }
}

