package com.kuaike.common.errorcode;

public enum CommonErrorCode implements UniverseErrorCode {

	UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1, "未知类型错误"),

	PARAM_ERROR(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 400, "请求参数不合法"),

	REQUIRE_PARAM(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 401, "缺少必要的请求参数"),

	SIGN_INVALIDATE(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 402, "参数检验不通过"),

	INVALIDATE_CLIENTID(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 403, "clientId不合法"),

	TOKEN_EXPIRE(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 405, "TOKEN超时"),

	TOKEN_REFRESH(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 406, "重复登陆"),

	TOKEN_ERROR(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 408, "TOKEN不合法"),

	NO_LOGIN(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 500, "用户未登录"),

	REQUEST_EXCEED(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 300, "超出请求次数限制"),

	NOT_FOUND(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 404, "所请求资源不存在"),

	IO_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 600, "后台处理IO异常"),

	NOT_EXISTS_OR_DELETED(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 666, "资源不存在或已被删除"),

	PERMISSION_DENY(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 700, "无请求该资源权限"),

	BUSINESS_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 800, "业务处理异常"),

	SYSTEM_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 9999, "系统处理异常"),

	LOGIN_NEED_CODE(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 1001, "请输入验证码"),

	;

	private ErrorSide errorSide;
	private Subsystem subsystem;
	private Platform platform;
	private int code;
	private String message;

	private CommonErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
		this.errorSide = errorSide;
		this.subsystem = subsystem;
		this.platform = platform;
		this.code = code;
		this.message = msg;
	}

	/*
	 * (non-Javadoc)
	 * 
	 */
	@Override
	public ErrorSide getErrorSide() {
		return errorSide;
	}

	/*
	 * (non-Javadoc)
	 * 
	 */
	@Override
	public Subsystem getSystem() {
		return subsystem;
	}

	/*
	 * (non-Javadoc)
	 * 
	 */
	@Override
	public Platform getPlatform() {
		return platform;
	}

	@Override
	public int getSubsystemErrorCode() {
		return code;
	}

	@Override
	public String getMessage() {
		return message;
	}

	@Override
	public CommonErrorCode fromCode(int code) {
		for (CommonErrorCode errorCode : values()) {
			if (errorCode.getSubsystemErrorCode() == code) {
				return errorCode;
			}
		}
		return CommonErrorCode.UNKNOW;
	}
}
