package com.kuaike.common.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SystemEnum {

    UNKNOW(0,"unknown","未知项目"),

    manager(1,"manager","skynet-manager服务"),

    link(2,"link","skynet项目"),

    logic(3,"logic","skynet-logic项目"),

    skynet_service(4,"skynet-service","skynet-service项目"),

    ;

    int id;

    String name;

    String desc;

    SystemEnum(int id, String name, String desc){
        this.id=id;
        this.name=name;
        this.desc=desc;
    }

    private static final Map<Integer, SystemEnum> MAP;

    private static final Map<String, SystemEnum> NAME_MAP;

    private static final Set<String> NameSet;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(SystemEnum.values()).collect(Collectors.toMap(SystemEnum::getId, Function.identity())));

        NAME_MAP = ImmutableMap.copyOf(
                Arrays.stream(SystemEnum.values()).collect(Collectors.toMap(SystemEnum::getName, Function.identity())));

        NameSet= ImmutableSet.copyOf(Arrays.stream(SystemEnum.values()).map(SystemEnum::getName).collect(Collectors.toSet()));
    }

    public static SystemEnum getSystemById(Integer id) {
        return MAP.get(id);
    }

    public static SystemEnum getSystemByName(String name) {
        return NAME_MAP.get(name);
    }

    public static boolean contains(String name){
        return NameSet.contains(name);
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }
}
