package com.kuaike.common.enums;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class EnumDto implements Serializable {

    private static final long serialVersionUID = 7346549324244920546L;

    private int id;

    private String name;

    public static EnumDto from(EnumService service) {
        if (service == null) {
            return null;
        }
        return new EnumDto(service.getValue(), service.getDesc());
    }

}
