/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.common.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SystemEnum {
    UNKNOW(0, "unknown", "\u672a\u77e5\u9879\u76ee"),
    manager(1, "manager", "skynet-manager\u670d\u52a1"),
    link(2, "link", "skynet\u9879\u76ee"),
    logic(3, "logic", "skynet-logic\u9879\u76ee"),
    skynet_service(4, "skynet-service", "skynet-service\u9879\u76ee");

    int id;
    String name;
    String desc;
    private static final Map<Integer, SystemEnum> MAP;
    private static final Map<String, SystemEnum> NAME_MAP;
    private static final Set<String> NameSet;

    private SystemEnum(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public static SystemEnum getSystemById(Integer id) {
        return MAP.get(id);
    }

    public static SystemEnum getSystemByName(String name) {
        return NAME_MAP.get(name);
    }

    public static boolean contains(String name) {
        return NameSet.contains(name);
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(SystemEnum.values()).collect(Collectors.toMap(SystemEnum::getId, Function.identity())));
        NAME_MAP = ImmutableMap.copyOf(Arrays.stream(SystemEnum.values()).collect(Collectors.toMap(SystemEnum::getName, Function.identity())));
        NameSet = ImmutableSet.copyOf((Collection)Arrays.stream(SystemEnum.values()).map(SystemEnum::getName).collect(Collectors.toSet()));
    }
}

